<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:59
 */
interface ProductionexecutionoutputDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionexecutionoutput 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionexecutionoutput primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionexecutionoutput productionexecutionoutput
 	 */
	public function insert($productionexecutionoutput);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionexecutionoutput productionexecutionoutput
 	 */
	public function update($productionexecutionoutput);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByExeutionid($value);

	public function queryByProductid($value);

	public function queryByAllprice($value);

	public function queryByHalfprice($value);

	public function queryByUnitprice($value);

	public function queryByNum($value);

	public function queryByCost($value);

	public function queryByStoreid($value);


	public function deleteByExeutionid($value);

	public function deleteByProductid($value);

	public function deleteByAllprice($value);

	public function deleteByHalfprice($value);

	public function deleteByUnitprice($value);

	public function deleteByNum($value);

	public function deleteByCost($value);

	public function deleteByStoreid($value);


}
?>